#!/bin/bash
#
# Script called from "run_HIRES_MESO.bash" to setup the processing environment for TC HiRes MESO winds. 
# Separate directories (by basin/sat/sector) are created for each new Storm or Invest that is geolocated 
# with a GOES MESO sector. All winds are then written to that directory for the life cycle of the storm/invest. 

run_ASF_AMV_Main_PATH=/data/smcd8/abailey/run_ASF_GEO_TC_HIRES_MESO/

sat=$1
sector=$2
basin=$3
yyyy=$4
StormNum=$5

echo ' ' 
echo "------------------------------------------------------------------------------------------------------------"
echo "Setup HiRes winds processing environment for GOES-$sat $sector $basin for Storm/Number $StormNum of year $yyyy"
echo ' ' 

# Check that we have a year directory for this storm
echo "ls ${run_ASF_AMV_Main_PATH}GOES-${sat}_TC_HIRES/${sector}/${basin}/${yyyy}"
      ls ${run_ASF_AMV_Main_PATH}GOES-${sat}_TC_HIRES/${sector}/${basin}/${yyyy}
command=$?

if [ $command -ne 0 ]; then
   echo ' '
   echo Need to create new directory for year $yyyy
   mkdir ${run_ASF_AMV_Main_PATH}GOES-${sat}_TC_HIRES/${sector}/${basin}/${yyyy}
fi

cd ${run_ASF_AMV_Main_PATH}GOES-${sat}_TC_HIRES/${sector}/${basin}/${yyyy}

mkdir $StormNum;cd $StormNum

# make all the processing directories required to run winds for this storm/invest
mkdir b-deck_files/ cron_logs/ Intermediate_Data_HIRES_${sector}/ ircd/ swcd/ vzcd/ wvcd/
mkdir Intermediate_Data_HIRES_${sector}/L1B
mkdir ircd/bufr swcd/bufr vzcd/bufr wvcd/bufr

# Link perl script needed for making BUFR files
ln -sf /data/home004/abailey/git-assisst_fw/BUFR/NPR.pl ircd/bufr/NPR.pl
ln -sf /data/home004/abailey/git-assisst_fw/BUFR/NPR.pl swcd/bufr/NPR.pl
ln -sf /data/home004/abailey/git-assisst_fw/BUFR/NPR.pl vzcd/bufr/NPR.pl
ln -sf /data/home004/abailey/git-assisst_fw/BUFR/NPR.pl wvcd/bufr/NPR.pl
echo ' ' 
echo "Done setting environment for GOES-$sat $sector $basin for Storm Number $StormNum of year $yyyy"
echo ' '
echo "---------------------------------------------------------------------------------------------"
