#!/bin/bash
# 
# Script to set the environment and run the ASF Cloud algorithms for HiRes MESO winds
#

echo ' ' 
date

# source the framework 2.0 develop branch environment
source /data/smcd8/abailey/ASF_Main_Latest_wCloudyPixels_And_HIRES_MESO_Mods/AlgorithmServices/setEnvGCC.sh gcc830
#source /data/smcd8/abailey/ASF_HIRES_MESO_GCC11/AlgorithmServices/setEnvGCC11.sh 


sat=$1
sector=$2
Output_Dir=$3
L1b_input=$4

# Set environment variables

#Export environmental variables describing the l1b input file
export ENV_SATELLITE=GOES$sat
export ENV_L1B_FILE=$L1b_input

# If running MESO, trim sector input for algorithms...
if [ "${sector:0:4}" = "MESO" ]
then
  export ENV_COVERAGE=${sector:0:4}
else
  export ENV_COVERAGE=$sector
fi

#Choose which algorithms output NetCDF product files. 
#By convention ABI_2KM comes before the product name for requesting ABI_2KM results.
export ENV_OUTPUT_LIST="ABI_2KM_LAND_MASK_NASA_1KM,NWP_GFS,CLOUD_MASK_EN,CLOUD_PHASE_EN,CLOUD_HEIGHT_EN"
# Examples of other outputs CLOUD_HEIGHT_EN,CLOUD_DCOMP_EN,CLOUD_LAYERS_EN,AEROSOL_AOD_EN,AVIATION_VOL_ASH_EN,AEROSOL_ADP_EN
echo "run to generate: $ENV_OUTPUT_LIST"

#Deviation from these numbers is only experimentally supported.
export ENV_NUM_COL_SEG=6
export ENV_NUM_ROW_SEG=4

#Set the desired snow mask algorithm used as precedence
#Choices: SNOW_MASK_NWP, SNOW_MASK_IMS_SSMI
#export ENV_SNOW_MASK_COMMON_ALG=SNOW_MASK_IMS_SSMI
export ENV_SNOW_MASK_COMMON_ALG=SNOW_MASK_IMS_SSMI
export ENV_SNOW_MAP_DIR=snow_map/ #must be set if ENV_SNOW_MASK_COMMON_ALG=SNOW_MASK_IMS_SSMI.


#export environmental variable for output and input directory
#export ENV_OUTPUT_DIRECTORY="./Output/"
export ENV_OUTPUT_DIRECTORY="$Output_Dir"
export ENV_INPUT_DIRECTORY="./Input/"

#Standard ancillary and LUT data environment variables
export ENV_ALGORITHM_ANCILLARY_DIR=algorithm_ancillary/
export ENV_FRAMEWORK_ANCILLARY_DIR=framework_ancillary/
#export ENV_OISST_DAILY_DIR=oisst_daily/
export ENV_ANCILLARY_SST_COMMON_ALG=CMCSST_DAILY
export ENV_CMCSST_DAILY_DIRECTORY=cmc_0.1deg_daily/
export ENV_OPTIONAL_ANC_SST=true

#export ENV_NWP_GFS_GRIB2_DIR=gfs_grib2_0.5deg-ait/
#export ENV_NWP_GFS_GRIB2_DIR=gfs_grib2_0.5deg/
export ENV_NWP_GFS_GRIB2_RESOLUTION="QUARTER_DEGREE"
export ENV_NWP_GFS_GRIB2_DIR=gfs_grib2_0.25deg/
#export ENV_NWP_GFS_GRIB2_DIR=gfs_grib2_0.25deg_star/

parallelRun=true
#parallelRun=false
##############################################################
# Call a sequential or parallel run
##############################################################
#Path to configuration XML
CFG="./Config/Projects/AIT_ABI_EN/Config.xml"
if [ "$parallelRun" != true ]
then
    bash Config/Projects/Sample_Execution/run_sequential_execution.sh ${CFG}
else
    MAX_JOBS=4
    TOTAL_SEG=$(($ENV_NUM_COL_SEG * $ENV_NUM_ROW_SEG))
#    JOB_ID="CLOUD_framework_job_`date +%Y%m%d%H%M%S_%N`_$$"
    JOB_ID="CLOUD_${sector}_framework_job_${Middle_Image_Time}"
    export JOB_ID
    bash Config/Projects/Sample_Execution/run_parallel_execution.sh ${CFG} ${JOB_ID} ${TOTAL_SEG} ${MAX_JOBS}
fi
##############################################################

date
