; make_TROPOMI_CO_mapper.pro
;
;Written by Chuanyu Xu on March 20, 2019
;
; Purpose: Makes global CO image for JSTAR Mapper
; 
; Inputs: afary     | Array of granules
;         img_dir   | Direcory where image will be written
;         year      | Year  (string)
;         month     | Month (string)
;         day       | Day   (string)
;         int_year  | Year  (integer)
;         int_month | Month (integer)
;         int_day   | Day   (integer)
;
; Called by: get_TROPOMI_CO_data.pro

pro make_TROPOMI_CO_mapper $
                      ,afary,     $
                     img_dir,   $
                     year,      $
                     month,     $
                     day,       $
                     int_year,  $
                     int_month, $
                     int_day

tic

   das = STRCOMPRESS(day, /REMOVE_ALL)
   moS = STRCOMPRESS(month, /REMOVE_all)
   yrS = STRCOMPRESS(year, /REMOVE_ALL)

   ; Extract the month and day from the date string
   if strlen(daS) eq 1 then daS = '0'+daS
   if strlen(moS) eq 1 then moS = '0'+moS

   ds = daS
   monstr = moS
   datestring=yrS+moS+daS
   ;spawn,'mkdir '+img_dir+ '/'
   fname_png = img_dir+'/'+'TROPOMI_Total_Column_CO_' + datestring + '.png'



   ct = 34

  ; Get the name of the current device. This name will be used with
  ; set_plot before the PostScript file is converted to .png

  thisdevice = !d.name
  
  ; Set size of image array (resolution)

  ; ***************************************************
  ; NOTE FOR Chuanyu
  ; The dimenisions for your image will be 8192 x 4096

; xsize = 32768L
; ysize = 16384L
  xsize = 32768L/4L
  ysize = 16384L/4L

  ; Set up the Z-Buffer Device

  set_plot, 'Z'

  pix_depth = 24

  device, decomposed=0, set_resolution=[xsize,ysize], $
          GET_PIXEL_DEPTH=pix_depth


  ; Initialize the image array and set all values to zero
  
  image = BytArr(xsize, ysize)
  image(*,*)=0B

  pos    = [0.0, 0.22, 0.0, 0.0]

  ; Load the colortable used for aerosols

  ;satellite_colorscale, r, g, b

; load colortable used for co

  loadct, 33

  ; Get the r, g, and b values for the color table that was just loaded.

  tvlct, r, g, b, /get

  ; Set up the index values for white, black, gray, and ocean color as the
  ; last four colors in the color table and assign
  ; r, g, b values for each of these colors

  ind_black=255
  ind_white=254
  ind_dkgray=253
  ind_gray=252

  ; Set up the top color, bottom color, and color step use for the 
  ; aerosol values. The entire color table is not used to plot
  ; data

  cbottom = 1
  ctop = ind_gray - 1

  datarange = [0,1]
  ncolors2 = ctop - cbottom + 1
 ; help, ncolors2
  step_color   = double(datarange(1) - datarange(0)) / ncolors2

  color_top = ind_gray - 1

  ; Load the modified color table into memory


 ;;;;;;;;;;;;;;;;;;
; DARK GREY-for Coastal Line
;;;;;;;;;;;;;;;;;;
R(253)=50
G(253)=50
B(253)=50

;;;;;;;;;;;;;;;;;;
; DARK GREY-for less than bottom limit.
;;;;;;;;;;;;;;;;;;
R(252)=102
G(252)=102
B(252)=102

;;;;;;;;;;;;;;;;;;
; WHITE
;;;;;;;;;;;;;;;;;;
;reserve 254 (white) - background and coastlines
R(254)  = 255
G(254)  = 255
B(254)  = 255


;;;;;;;;;;;;;;;;;;
; BLACK
;;;;;;;;;;;;;;;;;;
;reserve 255 (black) - text
R(255)  =0
G(255)  =0
B(255)  =0


  TvLct, r, g, b


  ; Set maximum and minimum value for AOT

;  minimumCO = 0
;  maximumCO = 3.0
  minimumCO = 0
  maximumCO = 0.1
  qf_filter=0.5

  n_granules = N_ELEMENTS(afary) ; Number of Granules
  
  print, 'Number of granule files to process ',n_granules
  
   for ig=0, n_granules-1 do begin
     ;Get CO data

     ;print, 'Working on (',ig,'): ',afary(ig)
     
     ; Skip empty strings in the array
     if afary(ig) eq '' then continue 

 ;    print,afary(ig)
     ;Open granule file
      file_ID = h5_parse(afary(ig),/read_data)
      lat_tropomi=file_id.PRODUCT.latitude.(12)
      lon_tropomi=file_id.PRODUCT.longitude.(12)
      co_tropomi=file_id.PRODUCT.carbonmonoxide_total_column.(12)
      qf_tropomi=file_id.product.qa_value.(12)

      ;convert quality flag into floating number and using -9.999 to replace filling value(=255) 
      s=size(lat_tropomi)
      qf_scale_factor=0.01
      qf_tropomi=float(qf_tropomi)*qf_scale_factor

      idx=where(qf_tropomi lt 0.0 or qf_tropomi gt 1.0 ,cnt)
      if cnt ge 1 then qf_tropomi(idx)=-9.99

      idx=where(co_tropomi eq 9.96921E36, cnt)
      if cnt ge 1 then co_tropomi(idx)=-9.999

      idx=where(co_tropomi gt maximumCO,cnt)
      if cnt ge 1 then co_tropomi(idx)=maximumCO

      ; congrid original data by a factor
      mag=8L
      lat2=congrid(lat_tropomi,s(1)*mag,s(2)*mag,/center,/interp)
      lon2=congrid(lon_tropomi,s(1)*mag,s(2)*mag,/center,/interp)
      ind1=where(lon_tropomi gt 178.0 and lon_tropomi le 360.0 ,ct1)
      ind2=where(lon_tropomi lt -178.0,ct2)
      ind3=where(lon_tropomi lt 0.0,ct3)
      if ct1 ge 1 and ct2 gt 1 then begin
      lon_tropomi1=lon_tropomi

      lon_tropomi1(ind3)=lon_tropomi(ind3)+360
      lon2=congrid(lon_tropomi1,s(1)*mag,s(2)*mag,/center,/interp)
      idx =where(lon2 gt 180.0,ct3)
      if ct3 ge 1 then lon2(idx)=lon2(idx)-360.0
      endif

      cot=congrid(co_tropomi,s(1)*mag,s(2)*mag)
      qft=congrid(qf_tropomi,s(1)*mag,s(2)*mag)

     ;Get Start and End Times
      g_start=file_id.time_coverage_start.(10)
      g_end=file_id.time_coverage_end.(10) 
;       print,g_start
;       print,g_end

     start_pos = STRPOS(g_start,'T')
     end_pos   = STRPOS(g_end,'T')

     start_day = STRMID(g_start,start_pos-2,2)
     end_day   = STRMID(g_end,end_pos-2,2)
   
     start_hour = STRMID(g_start,start_pos+1,2)
     end_hour   = STRMID(g_end,end_pos+1,2)

     hour_int = FIX(start_hour)
          
     ; Account for last day of month and leap years when calculating
     ; prev_day

     if int_day ne 1 then prev_day = int_day - 1
     if int_day eq 1 then begin
        if int_month eq (2 or 4 or 6 or 8 or 9 or 11 or 1) then begin
           prev_day = 31
        endif else begin
           if int_month ne 3 then prev_day = 30
           if int_month eq 3 then begin
              if yrs MOD 4 ne 0 then prev_day = 28
              if yrs MOD 4 eq 0 then prev_day = 29
           endif
        endelse
     endif

     ; Get rid of any Next Day data that is East of -90 and
     ; any of the previous day's data

     if (start_day ne daS OR start_day eq prev_day) then begin
        next_day = where(lon_tropomi gt -90, cnt)
        if (cnt gt 0) then co_tropomi[next_day] = -999
     endif

     ; Get rid of any current day data that is west of 100 and
     ; less than 04:00

     if (hour_int lt 4 and start_day eq daS) then begin

        curr_day = where(lon_tropomi lt 100, match_cnt)
        
        if (match_cnt ne 0) then co_tropomi[curr_day] = -999

     endif

     ;Chose data that meets the highest quality flag requirements
     ;val = where(qf_tropomi eq 0 AND qf_tropomi gt 0.5, cnt
;     val = where(qf_tropomi gt 0.0 AND CO_tropomi ne -999.9, cnt)
     val = where(qft ge qf_filter AND cot ne -999.9, cnt)
     
     if (cnt gt 0) then begin
           
;        new_co = co_tropomi[val]
        new_co = cot[val]
        ; Calculate x position of the selected pixels
;        x_cord = (lon_tropomi + 180)/360L
        x_cord = (lon2 + 180)/360L
        x_index = x_cord*(xsize - 1)
        x = x_index[val]

        ; Calculate y position of the selected pixels
;        y_cord = (lat_tropomi + 90)/180L
        y_cord = (lat2 + 90)/180L
        y_index = y_cord*(ysize - 1)
        y = y_index[val]

        image[x,y] = bytscl(new_co, min=minimumCO, max=maximumCO, top=ctop)
        idx = where(new_co gt maximumCO, nidx)
        if nidx gt 0 then image[x(idx),y(idx)] = ctop

        
      endif
      CATCH ,Error_status

        IF Error_status NE 0 THEN BEGIN
          CATCH, /CANCEL
        ENDIF


   endfor

   ; Write the PNG and make all pixels within image that have a value
   ; of zero transparent
   red = r  
   green = g  
   blue = b    
   ss=size(image)
   image=congrid(image,ss(1)*4,ss(2)*4) 
   WRITE_PNG,fname_png,image,red,green,blue,transparent=[0B]   

toc


end

