#!/bin/bash
#
#Written by Chuanyu Xu on March 20, 2019
#
# run_TROPOMI_CO_mapper.sh
#
# Purpose: Calls programs necessary to create the Global 
#          JSTAR Mapper image for TROPOMI CO
#
# Input : yr1 | Year 1 
#         mo1 | Month 1
#         da1 | Day 1
#         yr2 | Year 2
#         mo2 | Month 2
#         da2 | Day 2
#
# Called by: Run.run_TROPOMI_CO_mapper.sh
#
# Calls: get_TROPOMI_CO_data.pro
#       

yr1=$1
mo1=$2
da1=$3

yr2=$4
mo2=$5
da2=$6

yyyymmdd=$yr1$mo1$da1
# Set local directory  where global image will be written

local_dir=/data/smcd12/cxu/S5P/JSTARMapper/CO_scdr/TROPOMI
data_dir=/data/smcd12/cxu/S5P/JSTARMapper/CO_scdr/TROPOMI/PRODUCT
img_dir=/data/smcd12/cxu/S5P/JSTARMapper/CO_scdr/TROPOMI/IMAGE
#=====================================================

# compile make_TROPOMI_CO_quad.pro
cd $local_dir

#########################################################
#  start IDL 
#########################################################

#/data/starfs1/compilers/idl/idl85/bin/idl << EOD
/data/starfs1/compilers/idl_8.7.3/idl87/bin/idl << EOD

.compile get_TROPOMI_CO_data.pro
.compile make_TROPOMI_CO_mapper.pro
get_TROPOMI_CO_data, $yr1, $mo1, $da1, $yr2, $mo2, $da2, img_dir='${img_dir}',data_dir='${data_dir}'
exit
EOD



#if test -e $img_dir/"$imagename
#then
#   echo "File produced: $imagename"
#else
#   echo "No TROPOMI CO image was created"
#fi

