      SUBROUTINE MAXOUT(MAXO)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    MAXOUT
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 2002-05-14
C
C ABSTRACT: THIS SUBROUTINE ALLOWS AN APPLICATION PROGRAM TO SET THE
C  RECORD LENGTH OF NEWLY CREATED BUFR MESSAGES, OVERRIDING THE VALUE
C  SET IN BUFR ARCHIVE LIBRARY SUBROUTINE BFRINI.  THIS MUST BE CALLED
C  AFTER THE INITIAL CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE OPENBF
C  SINCE OPENBF CALLS BFRINI.  THE RECORD LENGTH WILL REMAIN MAX0
C  UNLESS THIS SUBROUTINE IS CALLED AGAIN WITH A NEW MAX0.
C
C PROGRAM HISTORY LOG:
C 2002-05-14  J. WOOLLEN -- ORIGINAL AUTHOR
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO FOR
C                           INFORMATIONAL PURPOSES
C 2004-08-09  J. ATOR    -- MAXIMUM MESSAGE LENGTH INCREASED FROM
C                           20,000 TO 50,000 BYTES
C 2006-04-14  J. ATOR    -- ADDED MAX0=0 OPTION AND OVERFLOW CHECK
C 2009-03-23  D. KEYSER  -- NO LONGER PRINTS THE RECORD LENGTH CHANGE
C                           DIAGNOSTIC IF THE REQUESTED RECORD LENGTH
C                           PASSED IN AS MAX0 IS ACTUALLY THE SAME AS
C                           THE PREVIOUS RECORD LENGTH
C 2009-04-21  J. ATOR    -- USE ERRWRT
C
C USAGE:    CALL MAXOUT (MAXO)
C   INPUT ARGUMENT LIST:
C     MAXO     - INTEGER: DESIRED MESSAGE LENGTH (BYTES):
C                       0 = SET RECORD LENGTH TO THE MAXIMUM ALLOWABLE
C
C REMARKS:
C    THIS ROUTINE CALLS:        ERRWRT
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      INCLUDE 'bufrlib.prm'

      COMMON /BITBUF/ MAXBYT,IBIT,IBAY(MXMSGLD4),MBYT(NFILES),
     .                MBAY(MXMSGLD4,NFILES)
      COMMON /MAXCMP/ MAXCMB,MAXROW,MAXCOL,NCMSGS,NCSUBS,NCBYTS
      COMMON /DXTAB / MAXDX,IDXV,NXSTR(10),LDXA(10),LDXB(10),LDXD(10),
     .                LD30(10),DXSTR(10)
      COMMON /QUIET / IPRT

      CHARACTER*128   ERRSTR
      CHARACTER*56    DXSTR

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      IF((MAXO.EQ.0).OR.(MAXO.GT.MXMSGL)) THEN
         NEWSIZ = MXMSGL
      ELSE
         NEWSIZ = MAXO
      ENDIF

      IF(IPRT.GE.0) THEN
         IF(MAXBYT.NE.NEWSIZ) THEN
      CALL ERRWRT('++++++++++++++BUFR ARCHIVE LIBRARY+++++++++++++++++')
      WRITE ( UNIT=ERRSTR, FMT='(A,A,I7,A,I7)' )
     . 'BUFRLIB: MAXOUT - THE RECORD LENGTH OF ALL BUFR MESSAGES ',
     . 'CREATED FROM THIS POINT ON IS BEING CHANGED FROM ', MAXBYT,
     . ' TO ', NEWSIZ
      CALL ERRWRT(ERRSTR)
      CALL ERRWRT('++++++++++++++BUFR ARCHIVE LIBRARY+++++++++++++++++')
      CALL ERRWRT(' ')
         ENDIF
      ENDIF

      MAXBYT = NEWSIZ
      MAXCMB = NEWSIZ
      MAXDX  = NEWSIZ

      RETURN
      END
