      SUBROUTINE SETBLOCK(IBLK) 

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM: SETBLOCK
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 2012-09-15
C
C ABSTRACT: SUBROUTINE SETBLOCK ALLOWS APPLICATIONS TO DEFINE WHAT
C           SORT OF OUTPUT FILE BLOCKING (IEEE RECORD CONTROL WORDS)
C           ARE APPLIED TO BUFR RECORDS WRITTEN FROM THE BUFRLIB
C           ROUTINES. THE DEFAULT IS NONE (PURE BUFR). OTHER OPTIONS
C           ARE BIG OR LITTLE ENDIAN.
C
C PROGRAM HISTORY LOG:
C 2012-09-15  J. WOOLLEN -- ORIGINAL AUTHOR
C
C USAGE: CALL SETBLOCK(IBLK)
C
C   INPUT ARGUMENTS:
C     IBLK - INTEGER BLOCK TYPE INDICATOR
C            -1  LITTLE ENDIAN RECORD CONTROL WORDS
C             0  NO RECORD CONTROL WORDS (PURE BUFR)
C             1  BIG ENDIAN RECORD CONTROL WORDS
C
C   OUTPUT ARGUMENTS:
C
C REMARKS:
C    THIS ROUTINE CALLS: OPENBF
C
C    THIS ROUTINE IS CALLED BY: USER
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /ENDORD/ IBLOCK,IORDBE(4),IORDLE(4)

c-----------------------------------------------------------------------
c-----------------------------------------------------------------------

      CALL OPENBF(0,'FIRST',0)
      IBLOCK=IBLK  

      RETURN
      END
