#!/usr/bin/python

"""
copy_ecn_data_to_ftp.py

  - copies existing files from ECN storage disks to STAR FTP server
  - given an ftp directory path, copies the files from the equivalent
    storage directory path to the ftp server
  - calls copy_dir_files_to_newdir.py to:
      - copy HDF and PNG files from storage path to ftp path
      - if file is HDF, uses cwexport to create a new netCDF-4 file
        at the ftp path

input:
  - reads a text listing of ftp paths to determine the destination paths
    ( the file containing the text listing is hardcoded below )

usage: ./copy_ecn_data_to_ftp.py

Ron Vogel, SMRC for NOAA CoastWatch
Jan 12, 2017
"""

import sys
#import re
import os
#import shutil
import commands
import copy_dir_files_to_newdir


ftp_home = '/data/aftp/socd1/ecn/data'
ecn_disk34 = '/disks/data034/data'
ecn_disk35 = '/disks/data035/data'

# read file to get ftp server's directories
#     Example list entry:  "mkdir $HOME/modis/k490noaa/daily/ob"
#     ( file is based on make_directories_ftp.sh ) 
#ftp_dir_list = open('ftp_directories.txt', 'r')
#ftp_dir_list = open('ftp_directories_GOES.txt', 'r')
#ftp_dir_list = open('ftp_directories_MODIS_1.txt', 'r')
#ftp_dir_list = open('ftp_directories_PODAAC_TEST.txt', 'r')
#ftp_dir_list = open('ftp_directories_PODAAC_ALL.txt', 'r')
#ftp_dir_list = open('ftp_directories_AVHRR.txt', 'r')
#ftp_dir_list = open('ftp_directories_MODIS_2.txt', 'r')
#ftp_dir_list = open('ftp_directories_VIIRS.txt', 'r')
#ftp_dir_list = open('ftp_directories_MODIS_Kd250.txt', 'r')
#ftp_dir_list = open('ftp_directories_MODIS_Kd250_2.txt', 'r')
ftp_dir_list = open('ftp_directories_AVHRR_annuals.txt', 'r')

for ftp_line in ftp_dir_list:
     ftp_line_stripd = ftp_line.strip()      # remove whitespace

     # determine sensor and decide which ECN storage disk contains the data
     dir_items = ftp_line_stripd.split('/')
     dir_item_one = dir_items[1]
     if dir_item_one == 'modis':
         ecn_disk = ecn_disk34
     else:
         ecn_disk = ecn_disk35

     # determine path to data on ECN storage disk
     dir_indx = ftp_line_stripd.find('/')
     ftp_dir = ftp_line_stripd[dir_indx:]
     ecn_path = ecn_disk + ftp_dir

     # determine full path on ftp server
     ftp_path = ftp_home + ftp_dir 

     print "ECN path: ", ecn_path
     print "FTP path: ", ftp_path

     # test both directories exist,
     # (sensor/product/interval/region may not be the same on ecn and ftp!)
     ecn_path_exists = os.path.exists(ecn_path)
     ftp_path_exists = os.path.exists(ftp_path)
     if ecn_path_exists and ftp_path_exists:
         try:
            cmd = './copy_dir_files_to_newdir.py --from_dir ' + ecn_path + ' --to_dir ' + ftp_path
            (status, output) = commands.getstatusoutput(cmd) # if error, command
                                                    # fails & status is non-zero
            if status:    # status is true (non-zero) upon cmd failure 
               sys.stderr.write(output)  # writes error message
               print '\n'
         except:
            print "Error copying files:"
            print "   from_dir: ", ecn_path
            print "   to_dir:   ", ftp_path
            print sys.exc_info()[0]
     else:
         print "Problem: the from_directory or to_directory path does not exist"
         print "         for files going to:"
         print ftp_path

ftp_dir_list.close()

