#!/bin/bash

# To use python modules, need to activate python3 in STAR's venv
# virtual environment.
# - This is described in STAR IT's Wiki document:
#   https://git.star.nesdis.noaa.gov/ITT/star-faq/-/wikis/Python
# - ECN's venv is located in:
#         /disks/data563/rvogel/python3_venv_environment
# - PYTHON_VENV env't variable is defined in:
#         utilities/create_env_var_global.sh
# - use $PYTHON_VENV to activate python3
# - DON'T FORGET TO deactivate PYTHON AFTER PYTHON SCRIPT COMPLETES


source /disks/data563/scripts/utilities/create_env_var_global.sh
source $PYTHON_VENV/activate

# run python script here
# e.g. using bash variables as argument inputs to python script
#      and writing python output to a log
# $SCRIPTDIR/pocloud_l3_subsetter.py -c $c -d $d -sd $sd -ed $ed -b=$bw,$bs,$be,$bn > $SCRIPTDIR_PROC/"mur_sst_download_log_"$region".log"

./python_script.py

deactivate

